/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.breakpoint.provider;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ParsingUtils;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org2.eclipse.php.internal.debug.core.sourcelookup.containers.LocalFileStorage;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;

public class PHPBreakpointProvider
implements IExecutableExtension {
    public IStatus addBreakpoint(AbstractThemeableEditor unifiedEditor, IEditorInput input, int editorLineNumber, int offset) throws CoreException {
        int originalLineNumber;
        int pos;
        block24: {
            IEditorInput editorInput = unifiedEditor.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                final Display display = unifiedEditor.getISourceViewer().getTextWidget().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)"Aptana PHP Debugger", (String)"The file you are trying to place a breakpoint on is an external (non-workspace) file. \nBreakpoints are supported for PHP files that are located inside projects.");
                    }
                });
                return Status.OK_STATUS;
            }
            pos = PHPBreakpointProvider.getValidPosition(unifiedEditor, editorLineNumber);
            IDocument doc = unifiedEditor.getISourceViewer().getDocument();
            originalLineNumber = editorLineNumber + 1;
            try {
                if (pos > -1) {
                    editorLineNumber = doc.getLineOfOffset(pos) + 1;
                    break block24;
                }
                return null;
            }
            catch (BadLocationException e) {
                PHPDebugEPLPlugin.logError(e);
                return new Status(4, "com.aptana.php.debug.epl", 4, "Invalid breakpoint locationgetRawPath();", null);
            }
        }
        Status status = null;
        IBreakpoint point = null;
        if (pos >= 0) {
            IResource res = this.getResourceFromInput(input);
            if (res != null && input instanceof IFileEditorInput) {
                Integer lineNumberInt = editorLineNumber;
                Integer originalLineNumberInt = originalLineNumber;
                IMarker[] breakpoints = res.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                if (breakpoints.length > 0) {
                    boolean found = false;
                    int i = 0;
                    while (i < breakpoints.length) {
                        Object object = breakpoints[i].getAttributes().get("lineNumber");
                        if (object.equals(lineNumberInt) || object.equals(originalLineNumberInt)) {
                            breakpoints[i].delete();
                            found = true;
                        }
                        ++i;
                    }
                    if (found) {
                        return null;
                    }
                }
                point = PHPDebugTarget.createBreakpoint(res, editorLineNumber);
            } else if (input instanceof IPathEditorInput) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                IPathEditorInput pa = (IPathEditorInput)input;
                String pathName = pa.getPath().toOSString();
                if (res instanceof IWorkspaceRoot) {
                    attributes.put("org2.eclipse.php.debug.core.Storage_Type", "org2.eclipse.php.debug.core.Remote");
                } else {
                    attributes.put("org2.eclipse.php.debug.core.Storage_Type", "org2.eclipse.php.debug.core.External");
                }
                attributes.put("org2.eclipse.php.debug.core.Storage_File", pathName);
                attributes.put("secondary_id", pathName);
                Integer lineNumberInt = new Integer(editorLineNumber);
                IMarker[] breakpoints = res.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                boolean found = false;
                int i = 0;
                while (i < breakpoints.length) {
                    if (breakpoints[i].getAttributes().get("lineNumber").equals(lineNumberInt)) {
                        breakpoints[i].delete();
                        found = true;
                    }
                    ++i;
                }
                if (found) {
                    return null;
                }
                point = PHPDebugTarget.createBreakpoint(res, editorLineNumber, attributes);
            } else if (input instanceof IStorageEditorInput) {
                String fileName;
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                HashMap<String, String> attributes = new HashMap<String, String>();
                String secondaryId = storage.getFullPath().toOSString();
                attributes.put("secondary_id", secondaryId);
                if (storage instanceof LocalFileStorage) {
                    IProject project;
                    attributes.put("org2.eclipse.php.debug.core.Storage_Type", "org2.eclipse.php.debug.core.Include");
                    fileName = ((LocalFileStorage)storage).getName();
                    String incDir = ((LocalFileStorage)storage).getIncBaseDirName();
                    if (incDir != null) {
                        fileName = secondaryId.substring(incDir.length() + 1);
                    }
                    attributes.put("org2.eclipse.php.debug.core.Project", (project = ((LocalFileStorage)storage).getProject()) != null ? project.getName() : "");
                    attributes.put("org2.eclipse.php.debug.core.Include_Path_Basedir", incDir != null ? incDir : "");
                } else {
                    attributes.put("org2.eclipse.php.debug.core.Storage_Type", "org2.eclipse.php.debug.core.Remote");
                    fileName = storage.getName();
                }
                attributes.put("org2.eclipse.php.debug.core.Storage_File", fileName);
                point = PHPDebugTarget.createBreakpoint(res, editorLineNumber, attributes);
            }
        }
        if (point == null) {
            PHPDebugEPLPlugin.logError("break point was not installed");
        }
        if (status == null) {
            status = new Status(0, "com.aptana.php.debug.epl", 0, MessageFormat.format(PHPDebugUIMessages.BreakpointCreated_1, new Object[0]), null);
        }
        return status;
    }

    public IResource getResource(IEditorInput input) {
        return this.getResourceFromInput(input);
    }

    private IResource getResourceFromInput(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null || !resource.exists()) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static int getValidPosition(AbstractThemeableEditor unifiedEditor, int editorLineNumber) {
        try {
            IDocument document = unifiedEditor.getISourceViewer().getDocument();
            IRegion lineInformation = document.getLineInformation(editorLineNumber);
            ITypedRegion[] typedRegions = document.getDocumentPartitioner().computePartitioning(lineInformation.getOffset(), lineInformation.getLength());
            boolean foundPHPPartition = false;
            if (typedRegions.length > 0 && typedRegions[0].getType().startsWith("__common_start_switch_tag")) {
                try {
                    IRegion nextLineInformation = document.getLineInformation(editorLineNumber + 1);
                    ITypedRegion[] nextTypeRegions = document.getDocumentPartitioner().computePartitioning(nextLineInformation.getOffset(), nextLineInformation.getLength());
                    if (nextTypeRegions.length > 0 && nextTypeRegions[0].getType().startsWith("__php_")) {
                        foundPHPPartition = true;
                        ++editorLineNumber;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            if (!foundPHPPartition) {
                ITypedRegion[] iTypedRegionArray = typedRegions;
                int n = typedRegions.length;
                int nextTypeRegions = 0;
                while (nextTypeRegions < n) {
                    ITypedRegion region = iTypedRegionArray[nextTypeRegions];
                    if (region.getType().startsWith("__php_")) {
                        foundPHPPartition = true;
                        break;
                    }
                    ++nextTypeRegions;
                }
            }
            if (foundPHPPartition) {
                ILexemeProvider lexemeProvider = ParsingUtils.createLexemeProvider((IDocument)document);
                int line = editorLineNumber;
                while (line < document.getNumberOfLines()) {
                    lineInformation = document.getLineInformation(line);
                    typedRegions = document.getDocumentPartitioner().computePartitioning(lineInformation.getOffset(), lineInformation.getOffset());
                    if (!foundPHPPartition && (typedRegions.length <= 0 || !typedRegions[0].getType().startsWith("__php_"))) break;
                    foundPHPPartition = false;
                    int checkLine = PHPBreakpointProvider.checkLine(line, document, (ILexemeProvider<PHPTokenType>)lexemeProvider);
                    if (checkLine != -1) {
                        return checkLine;
                    }
                    ++line;
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusLineMessageTimerManager.setErrorMessage((String)"Could not set a breakpoint at the selected line", (long)2000L, (boolean)true);
                }
            });
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private static int checkLine(int editorLineNumber, IDocument document, ILexemeProvider<PHPTokenType> lexemeProvider) throws BadLocationException {
        IRegion lineInformation = document.getLineInformation(editorLineNumber);
        int startIndex = lexemeProvider.getLexemeCeilingIndex(lineInformation.getOffset());
        int endIndex = lexemeProvider.getLexemeFloorIndex(lineInformation.getOffset() + lineInformation.getLength() - 1);
        int a = startIndex;
        while (a < endIndex) {
            Lexeme lexeme = lexemeProvider.getLexeme(a);
            PHPTokenType phpToken = (PHPTokenType)lexeme.getType();
            String tokenType = phpToken.getType();
            if (tokenType != "PHP_COMMENT" && tokenType != "PHP_LINE_COMMENT" && tokenType != "PHPDOC_COMMENT" && phpToken.getType() != "WHITESPACE") {
                int lineOffset = lineInformation.getOffset();
                return lineOffset;
            }
            ++a;
        }
        return -1;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    public static int getValidPosition(IDocument document, int newLine) {
        try {
            int checkLine = document.getLineOffset(newLine);
            return checkLine;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }
}

